<?php
// webhook for WhatsApp Business API (Cloud API or On-Prem)

$verify_token = "humans_token_123"; // same token you used in Meta webhook setup

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Verification challenge
    $mode = $_GET['hub_mode'] ?? '';
    $token = $_GET['hub_verify_token'] ?? '';
    $challenge = $_GET['hub_challenge'] ?? '';

    if ($mode === 'subscribe' && $token === $verify_token) {
        echo $challenge;
    } else {
        http_response_code(403);
        echo "Forbidden";
    }
} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle the incoming WhatsApp message
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    // Log or process the message
    file_put_contents("log.txt", json_encode($data, JSON_PRETTY_PRINT), FILE_APPEND);

    // You can process messages here
    if (isset($data['entry'][0]['changes'][0]['value']['messages'][0])) {
        $message = $data['entry'][0]['changes'][0]['value']['messages'][0];
        $from = $message['from'];
        $text = $message['text']['body'] ?? '';

        // Do something with the message
        file_put_contents("messages.txt", "From: $from - Message: $text\n", FILE_APPEND);
    }

    http_response_code(200); // Respond OK to WhatsApp
    echo "EVENT_RECEIVED";
} else {
    http_response_code(405);
    echo "Method Not Allowed";
}
